<?php
/**
 * @OA\Schema(
 *   schema="RecurringInvoice",
 *   type="object",
 *       @OA\Property(property="id", type="string", example="Opnel5aKBz", description="The hashed id of the recurring invoice"),
 *       @OA\Property(property="user_id", type="string", example="Opnel5aKBz", description="The user hashed id"),
 *       @OA\Property(property="assigned_user_id", type="string", example="Opnel5aKBz", description="The assigned user hashed id"),
 *       @OA\Property(property="company_id", type="string", example="Opnel5aKBz", description="The company hashed id"),
 *       @OA\Property(property="client_id", type="string", example="Opnel5aKBz", description="The client hashed id"),
 *       @OA\Property(property="status_id", type="string", example="4", description="The invoice status variable"),
 *       @OA\Property(property="frequency_id", type="number", example="4", description="The recurring invoice frequency"),
 *       @OA\Property(property="remaining_cycles", type="number", example="4", description="The number of invoices left to be generated"),
 *       @OA\Property(property="number", type="string", example="INV_101", description="The recurringinvoice number - is a unique alpha numeric number per invoice per company"),
 *       @OA\Property(property="po_number", type="string", example="PO-1234", description="The purchase order associated with this recurring invoice"),
 *       @OA\Property(property="terms", type="string", example="These are invoice terms", description="The invoice terms"),
 *       @OA\Property(property="public_notes", type="string", example="These are some public notes", description="The public notes of the invoice"),
 *       @OA\Property(property="private_notes", type="string", example="These are some private notes", description="The private notes of the invoice"),
 *       @OA\Property(property="footer", type="string", example="", description="The invoice footer notes"),
 *       @OA\Property(property="custom_value1", type="string", example="2022-10-01", description="A custom field value"),
 *       @OA\Property(property="custom_value2", type="string", example="Something custom", description="A custom field value"),
 *       @OA\Property(property="custom_value3", type="string", example="", description="A custom field value"),
 *       @OA\Property(property="custom_value4", type="string", example="", description="A custom field value"),
 *       @OA\Property(property="tax_name1", type="string", example="", description="The tax name"),
 *       @OA\Property(property="tax_name2", type="string", example="", description="The tax name"),
 *       @OA\Property(property="tax_rate1", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="tax_rate2", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="tax_name3", type="string", example="", description="The tax name"),
 *       @OA\Property(property="tax_rate3", type="number", format="float", example="10.00", description="The tax rate"),
 *       @OA\Property(property="total_taxes", type="number", format="float", example="10.00", description="The total taxes for the invoice"),
 *       @OA\Property(property="line_items", type="object", example="", description="An array of objects which define the line items of the invoice"),
 *       @OA\Property(property="amount", type="number", format="float", example="10.00", description="The invoice amount"),
 *       @OA\Property(property="balance", type="number", format="float", example="10.00", description="The invoice balance"),
 *       @OA\Property(property="paid_to_date", type="number", format="float", example="10.00", description="The amount paid on the invoice to date"),
 *       @OA\Property(property="discount", type="number", format="float", example="10.00", description="The invoice discount, can be an amount or a percentage"),
 *       @OA\Property(property="partial", type="number", format="float", example="10.00", description="The deposit/partial amount"),
 *       @OA\Property(property="is_amount_discount", type="boolean", example=true, description="Flag determining if the discount is an amount or a percentage"),
 *       @OA\Property(property="is_deleted", type="boolean", example=true, description="Defines if the invoice has been deleted"),
 *       @OA\Property(property="uses_inclusive_taxes", type="boolean", example=true, description="Defines the type of taxes used as either inclusive or exclusive"),
 *       @OA\Property(property="date", type="string", format="date", example="1994-07-30", description="The Invoice Date"),
 *       @OA\Property(property="last_sent_date", type="string", format="date", example="1994-07-30", description="The last date the invoice was sent out"),
 *       @OA\Property(property="next_send_date", type="string", format="date", example="1994-07-30", description="The Next date for a reminder to be sent"),
 *       @OA\Property(property="partial_due_date", type="string", format="date", example="1994-07-30", description="The due date for the deposit/partial amount"),
 *       @OA\Property(property="due_date", type="string", format="date", example="1994-07-30", description="The due date of the invoice"),
 *       @OA\Property(property="settings",ref="#/components/schemas/CompanySettings"),
 *       @OA\Property(property="last_viewed", type="number", format="integer", example="1434342123", description="Timestamp"),
 *       @OA\Property(property="updated_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 *       @OA\Property(property="archived_at", type="number", format="integer", example="1434342123", description="Timestamp"),
 *       @OA\Property(property="custom_surcharge1", type="number", format="float", example="10.00", description="First Custom Surcharge"),
 *       @OA\Property(property="custom_surcharge2", type="number", format="float", example="10.00", description="Second Custom Surcharge"),
 *       @OA\Property(property="custom_surcharge3", type="number", format="float", example="10.00", description="Third Custom Surcharge"),
 *       @OA\Property(property="custom_surcharge4", type="number", format="float", example="10.00", description="Fourth Custom Surcharge"),
 *       @OA\Property(property="custom_surcharge_tax1", type="boolean", example=true, description="Toggles charging taxes on custom surcharge amounts"),
 *       @OA\Property(property="custom_surcharge_tax2", type="boolean", example=true, description="Toggles charging taxes on custom surcharge amounts"),
 *       @OA\Property(property="custom_surcharge_tax3", type="boolean", example=true, description="Toggles charging taxes on custom surcharge amounts"),
 *       @OA\Property(property="custom_surcharge_tax4", type="boolean", example=true, description="Toggles charging taxes on custom surcharge amounts"),
 * )
 */
