<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Currency Codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdCurrencyCodes
{
    /**
     * UAE Dirham
     */
    const UAE_DIRHAM = "AED";

    /**
     * Afghani
     */
    const AFGHANI = "AFN";

    /**
     * Lek
     */
    const LEK = "ALL";

    /**
     * Armenian Dram
     */
    const ARMENIAN_DRAM = "AMD";

    /**
     * Netherlands Antillean Guilder
     */
    const NETHERLANDS_ANTILLEAN_GUILDER = "ANG";

    /**
     * Kwanza
     */
    const KWANZA = "AOA";

    /**
     * Argentine Peso
     */
    const ARGENTINE_PESO = "ARS";

    /**
     * Australian Dollar
     */
    const AUSTRALIAN_DOLLAR = "AUD";

    /**
     * Aruban Florin
     */
    const ARUBAN_FLORIN = "AWG";

    /**
     * Azerbaijan Manat
     */
    const AZERBAIJAN_MANAT = "AZN";

    /**
     * Convertible Mark
     */
    const CONVERTIBLE_MARK = "BAM";

    /**
     * Barbados Dollar
     */
    const BARBADOS_DOLLAR = "BBD";

    /**
     * Taka
     */
    const TAKA = "BDT";

    /**
     * Bulgarian Lev
     */
    const BULGARIAN_LEV = "BGN";

    /**
     * Bahraini Dinar
     */
    const BAHRAINI_DINAR = "BHD";

    /**
     * Burundi Franc
     */
    const BURUNDI_FRANC = "BIF";

    /**
     * Bermudian Dollar
     */
    const BERMUDIAN_DOLLAR = "BMD";

    /**
     * Brunei Dollar
     */
    const BRUNEI_DOLLAR = "BND";

    /**
     * Boliviano
     */
    const BOLIVIANO = "BOB";

    /**
     * Mvdol
     */
    const MVDOL = "BOV";

    /**
     * Brazilian Real
     */
    const BRAZILIAN_REAL = "BRL";

    /**
     * Bahamian Dollar
     */
    const BAHAMIAN_DOLLAR = "BSD";

    /**
     * Ngultrum
     */
    const NGULTRUM = "BTN";

    /**
     * Pula
     */
    const PULA = "BWP";

    /**
     * Belarusian Ruble
     */
    const BELARUSIAN_RUBLE = "BYN";

    /**
     * Belize Dollar
     */
    const BELIZE_DOLLAR = "BZD";

    /**
     * Canadian Dollar
     */
    const CANADIAN_DOLLAR = "CAD";

    /**
     * Congolese Franc
     */
    const CONGOLESE_FRANC = "CDF";

    /**
     * WIR Euro
     */
    const WIR_EURO = "CHE";

    /**
     * Swiss Franc
     */
    const SWISS_FRANC = "CHF";

    /**
     * WIR Franc
     */
    const WIR_FRANC = "CHW";

    /**
     * Unidad de Fomento
     */
    const UNIDAD_DE_FOMENTO = "CLF";

    /**
     * Chilean Peso
     */
    const CHILEAN_PESO = "CLP";

    /**
     * Yuan Renminbi
     */
    const YUAN_RENMINBI = "CNY";

    /**
     * Colombian Peso
     */
    const COLOMBIAN_PESO = "COP";

    /**
     * Unidad de Valor Real
     */
    const UNIDAD_DE_VALOR_REAL = "COU";

    /**
     * Costa Rican Colon
     */
    const COSTA_RICAN_COLON = "CRC";

    /**
     * Peso Convertible
     */
    const PESO_CONVERTIBLE = "CUC";

    /**
     * Cuban Peso
     */
    const CUBAN_PESO = "CUP";

    /**
     * Cabo Verde Escudo
     */
    const CABO_VERDE_ESCUDO = "CVE";

    /**
     * Czech Koruna
     */
    const CZECH_KORUNA = "CZK";

    /**
     * Djibouti Franc
     */
    const DJIBOUTI_FRANC = "DJF";

    /**
     * Danish Krone
     */
    const DANISH_KRONE = "DKK";

    /**
     * Dominican Peso
     */
    const DOMINICAN_PESO = "DOP";

    /**
     * Algerian Dinar
     */
    const ALGERIAN_DINAR = "DZD";

    /**
     * Egyptian Pound
     */
    const EGYPTIAN_POUND = "EGP";

    /**
     * Nakfa
     */
    const NAKFA = "ERN";

    /**
     * Ethiopian Birr
     */
    const ETHIOPIAN_BIRR = "ETB";

    /**
     * Euro
     */
    const EURO = "EUR";

    /**
     * Fiji Dollar
     */
    const FIJI_DOLLAR = "FJD";

    /**
     * Falkland Islands Pound
     */
    const FALKLAND_ISLANDS_POUND = "FKP";

    /**
     * Pound Sterling
     */
    const POUND_STERLING = "GBP";

    /**
     * Lari
     */
    const LARI = "GEL";

    /**
     * Ghana Cedi
     */
    const GHANA_CEDI = "GHS";

    /**
     * Gibraltar Pound
     */
    const GIBRALTAR_POUND = "GIP";

    /**
     * Dalasi
     */
    const DALASI = "GMD";

    /**
     * Guinean Franc
     */
    const GUINEAN_FRANC = "GNF";

    /**
     * Quetzal
     */
    const QUETZAL = "GTQ";

    /**
     * Guyana Dollar
     */
    const GUYANA_DOLLAR = "GYD";

    /**
     * Hong Kong Dollar
     */
    const HONG_KONG_DOLLAR = "HKD";

    /**
     * Lempira
     */
    const LEMPIRA = "HNL";

    /**
     * Kuna
     */
    const KUNA = "HRK";

    /**
     * Gourde
     */
    const GOURDE = "HTG";

    /**
     * Forint
     */
    const FORINT = "HUF";

    /**
     * Rupiah
     */
    const RUPIAH = "IDR";

    /**
     * New Israeli Sheqel
     */
    const NEW_ISRAELI_SHEQEL = "ILS";

    /**
     * Indian Rupee
     */
    const INDIAN_RUPEE = "INR";

    /**
     * Iraqi Dinar
     */
    const IRAQI_DINAR = "IQD";

    /**
     * Iranian Rial
     */
    const IRANIAN_RIAL = "IRR";

    /**
     * Iceland Krona
     */
    const ICELAND_KRONA = "ISK";

    /**
     * Jamaican Dollar
     */
    const JAMAICAN_DOLLAR = "JMD";

    /**
     * Jordanian Dinar
     */
    const JORDANIAN_DINAR = "JOD";

    /**
     * Yen
     */
    const YEN = "JPY";

    /**
     * Kenyan Shilling
     */
    const KENYAN_SHILLING = "KES";

    /**
     * Som
     */
    const SOM = "KGS";

    /**
     * Riel
     */
    const RIEL = "KHR";

    /**
     * Comorian Franc
     */
    const COMORIAN_FRANC = "KMF";

    /**
     * North Korean Won
     */
    const NORTH_KOREAN_WON = "KPW";

    /**
     * Won
     */
    const WON = "KRW";

    /**
     * Kuwaiti Dinar
     */
    const KUWAITI_DINAR = "KWD";

    /**
     * Cayman Islands Dollar
     */
    const CAYMAN_ISLANDS_DOLLAR = "KYD";

    /**
     * Tenge
     */
    const TENGE = "KZT";

    /**
     * Lao Kip
     */
    const LAO_KIP = "LAK";

    /**
     * Lebanese Pound
     */
    const LEBANESE_POUND = "LBP";

    /**
     * Sri Lanka Rupee
     */
    const SRI_LANKA_RUPEE = "LKR";

    /**
     * Liberian Dollar
     */
    const LIBERIAN_DOLLAR = "LRD";

    /**
     * Loti
     */
    const LOTI = "LSL";

    /**
     * Libyan Dinar
     */
    const LIBYAN_DINAR = "LYD";

    /**
     * Moroccan Dirham
     */
    const MOROCCAN_DIRHAM = "MAD";

    /**
     * Moldovan Leu
     */
    const MOLDOVAN_LEU = "MDL";

    /**
     * Malagasy Ariary
     */
    const MALAGASY_ARIARY = "MGA";

    /**
     * Denar
     */
    const DENAR = "MKD";

    /**
     * Kyat
     */
    const KYAT = "MMK";

    /**
     * Tugrik
     */
    const TUGRIK = "MNT";

    /**
     * Pataca
     */
    const PATACA = "MOP";

    /**
     * Ouguiya
     */
    const OUGUIYA = "MRU";

    /**
     * Mauritius Rupee
     */
    const MAURITIUS_RUPEE = "MUR";

    /**
     * Rufiyaa
     */
    const RUFIYAA = "MVR";

    /**
     * Malawi Kwacha
     */
    const MALAWI_KWACHA = "MWK";

    /**
     * Mexican Peso
     */
    const MEXICAN_PESO = "MXN";

    /**
     * Mexican Unidad de Inversion (UDI)
     */
    const MEXICAN_UNIDAD_DE_INVERSION_UDI = "MXV";

    /**
     * Malaysian Ringgit
     */
    const MALAYSIAN_RINGGIT = "MYR";

    /**
     * Mozambique Metical
     */
    const MOZAMBIQUE_METICAL = "MZN";

    /**
     * Namibia Dollar
     */
    const NAMIBIA_DOLLAR = "NAD";

    /**
     * Naira
     */
    const NAIRA = "NGN";

    /**
     * Cordoba Oro
     */
    const CORDOBA_ORO = "NIO";

    /**
     * Norwegian Krone
     */
    const NORWEGIAN_KRONE = "NOK";

    /**
     * Nepalese Rupee
     */
    const NEPALESE_RUPEE = "NPR";

    /**
     * New Zealand Dollar
     */
    const NEW_ZEALAND_DOLLAR = "NZD";

    /**
     * Rial Omani
     */
    const RIAL_OMANI = "OMR";

    /**
     * Balboa
     */
    const BALBOA = "PAB";

    /**
     * Sol
     */
    const SOL = "PEN";

    /**
     * Kina
     */
    const KINA = "PGK";

    /**
     * Philippine Peso
     */
    const PHILIPPINE_PESO = "PHP";

    /**
     * Pakistan Rupee
     */
    const PAKISTAN_RUPEE = "PKR";

    /**
     * Zloty
     */
    const ZLOTY = "PLN";

    /**
     * Guarani
     */
    const GUARANI = "PYG";

    /**
     * Qatari Rial
     */
    const QATARI_RIAL = "QAR";

    /**
     * Romanian Leu
     */
    const ROMANIAN_LEU = "RON";

    /**
     * Serbian Dinar
     */
    const SERBIAN_DINAR = "RSD";

    /**
     * Russian Ruble
     */
    const RUSSIAN_RUBLE = "RUB";

    /**
     * Rwanda Franc
     */
    const RWANDA_FRANC = "RWF";

    /**
     * Saudi Riyal
     */
    const SAUDI_RIYAL = "SAR";

    /**
     * Solomon Islands Dollar
     */
    const SOLOMON_ISLANDS_DOLLAR = "SBD";

    /**
     * Seychelles Rupee
     */
    const SEYCHELLES_RUPEE = "SCR";

    /**
     * Sudanese Pound
     */
    const SUDANESE_POUND = "SDG";

    /**
     * Swedish Krona
     */
    const SWEDISH_KRONA = "SEK";

    /**
     * Singapore Dollar
     */
    const SINGAPORE_DOLLAR = "SGD";

    /**
     * Saint Helena Pound
     */
    const SAINT_HELENA_POUND = "SHP";

    /**
     * Leone
     */
    const LEONE = "SLL";

    /**
     * Somali Shilling
     */
    const SOMALI_SHILLING = "SOS";

    /**
     * Surinam Dollar
     */
    const SURINAM_DOLLAR = "SRD";

    /**
     * South Sudanese Pound
     */
    const SOUTH_SUDANESE_POUND = "SSP";

    /**
     * Dobra
     */
    const DOBRA = "STN";

    /**
     * El Salvador Colon
     */
    const EL_SALVADOR_COLON = "SVC";

    /**
     * Syrian Pound
     */
    const SYRIAN_POUND = "SYP";

    /**
     * Lilangeni
     */
    const LILANGENI = "SZL";

    /**
     * Baht
     */
    const BAHT = "THB";

    /**
     * Somoni
     */
    const SOMONI = "TJS";

    /**
     * Turkmenistan New Manat
     */
    const TURKMENISTAN_NEW_MANAT = "TMT";

    /**
     * Tunisian Dinar
     */
    const TUNISIAN_DINAR = "TND";

    /**
     * Pa’anga
     */
    const PAANGA = "TOP";

    /**
     * Turkish Lira
     */
    const TURKISH_LIRA = "TRY";

    /**
     * Trinidad and Tobago Dollar
     */
    const TRINIDAD_AND_TOBAGO_DOLLAR = "TTD";

    /**
     * New Taiwan Dollar
     */
    const NEW_TAIWAN_DOLLAR = "TWD";

    /**
     * Tanzanian Shilling
     */
    const TANZANIAN_SHILLING = "TZS";

    /**
     * Hryvnia
     */
    const HRYVNIA = "UAH";

    /**
     * Uganda Shilling
     */
    const UGANDA_SHILLING = "UGX";

    /**
     * US Dollar
     */
    const US_DOLLAR = "USD";

    /**
     * US Dollar (Next day)
     */
    const US_DOLLAR_NEXT_DAY = "USN";

    /**
     * Uruguay Peso en Unidades Indexadas (UI)
     */
    const URUGUAY_PESO_EN_UNIDADES_INDEXADAS_UI = "UYI";

    /**
     * Peso Uruguayo
     */
    const PESO_URUGUAYO = "UYU";

    /**
     * Unidad Previsional
     */
    const UNIDAD_PREVISIONAL = "UYW";

    /**
     * Uzbekistan Sum
     */
    const UZBEKISTAN_SUM = "UZS";

    /**
     * Bolívar Soberano
     */
    const BOLVAR_SOBERANO = "VES";

    /**
     * Dong
     */
    const DONG = "VND";

    /**
     * Vatu
     */
    const VATU = "VUV";

    /**
     * Tala
     */
    const TALA = "WST";

    /**
     * CFA Franc BEAC
     */
    const CFA_FRANC_BEAC = "XAF";

    /**
     * Silver
     */
    const SILVER = "XAG";

    /**
     * Gold
     */
    const GOLD = "XAU";

    /**
     * Bond Markets Unit European Composite Unit (EURCO)
     */
    const BOND_MARKETS_UNIT_EUROPEAN_COMPOSITE_UNIT_EURCO = "XBA";

    /**
     * Bond Markets Unit European Monetary Unit (E.M.U.-6)
     */
    const BOND_MARKETS_UNIT_EUROPEAN_MONETARY_UNIT_EMU6 = "XBB";

    /**
     * Bond Markets Unit European Unit of Account 9 (E.U.A.-9)
     */
    const BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_9_EUA9 = "XBC";

    /**
     * Bond Markets Unit European Unit of Account 17 (E.U.A.-17)
     */
    const BOND_MARKETS_UNIT_EUROPEAN_UNIT_OF_ACCOUNT_17_EUA17 = "XBD";

    /**
     * East Caribbean Dollar
     */
    const EAST_CARIBBEAN_DOLLAR = "XCD";

    /**
     * SDR (Special Drawing Right)
     */
    const SDR_SPECIAL_DRAWING_RIGHT = "XDR";

    /**
     * CFA Franc BCEAO
     */
    const CFA_FRANC_BCEAO = "XOF";

    /**
     * Palladium
     */
    const PALLADIUM = "XPD";

    /**
     * CFP Franc
     */
    const CFP_FRANC = "XPF";

    /**
     * Platinum
     */
    const PLATINUM = "XPT";

    /**
     * Sucre
     */
    const SUCRE = "XSU";

    /**
     * Codes specifically reserved for testing purposes
     */
    const CODES_SPECIFICALLY_RESERVED_FOR_TESTING_PURPOSES = "XTS";

    /**
     * ADB Unit of Account
     */
    const ADB_UNIT_OF_ACCOUNT = "XUA";

    /**
     * The codes assigned for transactions where no currency is involved
     */
    const THE_CODES_ASSIGNED_FOR_TRANSACTIONS_WHERE_NO_CURRENCY_IS_INVOLVED = "XXX";

    /**
     * Yemeni Rial
     */
    const YEMENI_RIAL = "YER";

    /**
     * Rand
     */
    const RAND = "ZAR";

    /**
     * Zambian Kwacha
     */
    const ZAMBIAN_KWACHA = "ZMW";

    /**
     * Zimbabwe Dollar
     */
    const ZIMBABWE_DOLLAR = "ZWL";
}
