<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class EventsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\Event(array());
        $this->assertNotNull($obj);
    }
    
    public function testEventsList()
    {
        $fixture = $this->loadJsonFixture('events')->list;
        $this->stub_request($fixture);

        $service = $this->client->events();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->events;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\Event', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->action, $record->action);
            $this->assertEquals($body[$num]->created_at, $record->created_at);
            $this->assertEquals($body[$num]->customer_notifications, $record->customer_notifications);
            $this->assertEquals($body[$num]->details, $record->details);
            $this->assertEquals($body[$num]->id, $record->id);
            $this->assertEquals($body[$num]->links, $record->links);
            $this->assertEquals($body[$num]->metadata, $record->metadata);
            $this->assertEquals($body[$num]->resource_type, $record->resource_type);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testEventsGet()
    {
        $fixture = $this->loadJsonFixture('events')->get;
        $this->stub_request($fixture);

        $service = $this->client->events();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->events;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\Event', $response);

        $this->assertEquals($body->action, $response->action);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->customer_notifications, $response->customer_notifications);
        $this->assertEquals($body->details, $response->details);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
        $this->assertEquals($body->resource_type, $response->resource_type);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
