<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class CloudAiNlLlmProtoServicePartBlob extends \Google\Model
{
  /**
   * @var string
   */
  public $data;
  /**
   * @var string
   */
  public $mimeType;
  /**
   * @var CloudAiNlLlmProtoServicePartFileData
   */
  public $originalFileData;
  protected $originalFileDataType = CloudAiNlLlmProtoServicePartFileData::class;
  protected $originalFileDataDataType = '';

  /**
   * @param string
   */
  public function setData($data)
  {
    $this->data = $data;
  }
  /**
   * @return string
   */
  public function getData()
  {
    return $this->data;
  }
  /**
   * @param string
   */
  public function setMimeType($mimeType)
  {
    $this->mimeType = $mimeType;
  }
  /**
   * @return string
   */
  public function getMimeType()
  {
    return $this->mimeType;
  }
  /**
   * @param CloudAiNlLlmProtoServicePartFileData
   */
  public function setOriginalFileData(CloudAiNlLlmProtoServicePartFileData $originalFileData)
  {
    $this->originalFileData = $originalFileData;
  }
  /**
   * @return CloudAiNlLlmProtoServicePartFileData
   */
  public function getOriginalFileData()
  {
    return $this->originalFileData;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CloudAiNlLlmProtoServicePartBlob::class, 'Google_Service_Aiplatform_CloudAiNlLlmProtoServicePartBlob');
